#!/bin/sh
#
# This script removes the unified NVidia driver.  It basically boils down to
# three commands; you could just as easily run them by hand.
#
# This driver and removal script are intended to be used within BeOS
# ( http://www.be.com/products/freebeos/ ).  If you are not already within
# BeOS, reboot into BeOS before attempting removal.
#
# Q: HELP!  This file opened in an editor!  What do I do?
#
# A: This happens to some BeOS users; I have not yet figured out why.  If
#    this happens to you, try the following procedure:
#
#	o From the BeOS menu, open a command line Terminal by selecting
#	  BeOS->Applications->Terminal.
#	o Using the mouse, drag the icon for the remove-nvidia-driver.sh
#	  file into the Terminal window.  The full path name of the file will
#	  automatically be entered on the command line.
#	o Press ENTER in the Terminal window.  The removal process should
#	  begin.
#
# Bugs:
#	This script is not terribly robust.  Try not to stress it; 'bash'
#	isn't my first language.
#
# Leo L. Schwab						2001.01.04
#

ask() {
  until
    echo -n "$1"
    if ! read
    then
      echo EOF
      exit 1
    fi
    case $REPLY in 
      y|yes|n|no) true ;;
      *) false;;
    esac
  do
  echo please answer yes or no
  done
  case $REPLY in n|no) return 1 ;; esac
  return 0
}


# Where to find stuff.
#
ADD_ONS="/system/add-ons"
DRIVERDIR="/system/add-ons/kernel/drivers/bin"
OLDDRIVERS="rivatnt riva128"
DEV="nvidia"


# Check if we're launched from the Tracker
#
if [ ! -t 1 ]; then
	# Launched from Tracker; open a shell window and run from there.
	export INWINDOW=1
	Terminal -t "Uninstaller Diagnostic Output" /bin/sh "$0"
	unset INWINDOW
	exit 0
fi


# Say hello
#
msg=$'Remove Experimental Unified NVidia Graphics Driver\n\n'
msg="$msg"$'This script will remove the experimental unified driver for '
msg="$msg"$'NVidia-based graphics cards.'
alert "$msg" > /dev/null 2>&1

# Warn the user and get confirmation.
#
msg=$'This script will DELETE the NVidia-related files in your /system '
msg="$msg"$'directory, and restore the old R5 RIVA 128 and TNT drivers.  '
msg="$msg"$'If you wish to re-install later, you will need to locate and '
msg="$msg"$'use the files you originally used to install the driver.\n\n'
msg="$msg"$'Do you wish to DELETE the NVidia driver?'

if [ `alert --warning "$msg" "Yes" "No"` == "No" ]; then
	alert --stop "Uninstallation aborted." "Exit" > /dev/null 2>&1
	exit 0
fi


# Delete NVidia driver files.
#
echo "Deleting NVidia driver files..."
rm -f $ADD_ONS/kernel/drivers/dev/graphics/$DEV
rm -f $ADD_ONS/kernel/drivers/bin/$DEV
rm -f $ADD_ONS/accelerants/$DEV.accelerant

# Restore old R5 drivers.
#
echo "Restoring old R5 RIVA drivers:"
for drv in $OLDDRIVERS; do
	if [ -e $DRIVERDIR/$drv-disabled ]; then
		echo "...$drv"
		mv $DRIVERDIR/$drv-disabled $DRIVERDIR/$drv
	fi
done
unset drv
echo "Done."

# All done!
#
msg=$'Original R5 drivers restored.\n\n'
msg="$msg"$'Please reboot to complete uninstallation.'
alert "$msg" "Exit" > /dev/null 2>&1

unset msg
